/**
 * Created by Acer on 2016-11-21.
 */
$(function() {
    $('.tabBody').remove();
    $('.docking_bg_l').remove();
    var department_icon = 'M109.634,164.452c20.179,0,37.402-7.135,51.674-21.411c14.277-14.275,21.416-31.503,21.416-51.678    c0-20.173-7.139-37.401-21.416-51.678c-14.272-14.275-31.496-21.414-51.674-21.414c-20.177,0-37.401,7.139-51.676,21.414    C43.684,53.962,36.545,71.186,36.545,91.363c0,20.179,7.139,37.403,21.413,51.678C72.233,157.313,89.457,164.452,109.634,164.452z    M196.569,278.519c21.413,21.406,47.248,32.114,77.516,32.114c30.269,0,56.103-10.708,77.515-32.114    c21.409-21.42,32.117-47.258,32.117-77.52c0-30.264-10.708-56.101-32.117-77.515c-21.412-21.414-47.246-32.121-77.515-32.121    c-30.268,0-56.105,10.709-77.516,32.121c-21.411,21.411-32.12,47.248-32.12,77.515S175.158,257.102,196.569,278.519zM438.543,164.452c20.17,0,37.397-7.135,51.671-21.411c14.274-14.275,21.409-31.503,21.409-51.678    c0-20.173-7.135-37.401-21.409-51.678c-14.273-14.275-31.501-21.414-51.671-21.414c-20.184,0-37.407,7.139-51.682,21.414    c-14.271,14.277-21.409,31.501-21.409,51.678c0,20.179,7.139,37.403,21.409,51.678    C401.136,157.313,418.359,164.452,438.543,164.452zM512.763,164.456c-1.136,0-5.276,1.999-12.415,5.996c-7.132,3.999-16.416,8.044-27.833,12.137    c-11.416,4.089-22.747,6.136-33.972,6.136c-12.758,0-25.406-2.187-37.973-6.567c0.945,7.039,1.424,13.322,1.424,18.842    c0,26.457-7.71,50.819-23.134,73.089c30.841,0.955,56.056,13.134,75.668,36.552h38.256c15.605,0,28.739-3.863,39.396-11.57    c10.657-7.703,15.989-18.986,15.989-33.83C548.172,198.047,536.376,164.452,512.763,164.456zM470.096,395.284c-1.999-11.136-4.524-21.464-7.57-30.978c-3.046-9.521-7.139-18.794-12.271-27.836    c-5.141-9.034-11.044-16.748-17.706-23.127c-6.667-6.379-14.805-11.464-24.414-15.276c-9.609-3.806-20.225-5.708-31.833-5.708    c-1.906,0-5.996,2.047-12.278,6.14c-6.283,4.089-13.224,8.665-20.841,13.702c-7.615,5.037-17.789,9.609-30.55,13.702    c-12.762,4.093-25.608,6.14-38.544,6.14c-12.941,0-25.791-2.047-38.544-6.14c-12.756-4.093-22.936-8.665-30.55-13.702    c-7.616-5.037-14.561-9.613-20.841-13.702c-6.283-4.093-10.373-6.14-12.279-6.14c-11.609,0-22.22,1.902-31.833,5.708    c-9.613,3.812-17.749,8.897-24.41,15.276c-6.667,6.372-12.562,14.093-17.705,23.127c-5.137,9.042-9.229,18.315-12.275,27.836    c-3.045,9.514-5.564,19.842-7.566,30.978c-2,11.136-3.331,21.505-3.997,31.121c-0.667,9.613-0.999,19.466-0.999,29.554    c0,22.836,6.945,40.874,20.839,54.098c13.899,13.223,32.363,19.842,55.389,19.842h249.535c23.028,0,41.49-6.619,55.392-19.842    c13.894-13.224,20.841-31.262,20.841-54.098c0-10.088-0.335-19.938-0.992-29.554C473.418,416.789,472.087,406.419,470.096,395.284    zM169.303,274.088c-15.418-22.27-23.125-46.632-23.122-73.089c0-5.52,0.477-11.799,1.427-18.842    c-12.564,4.377-25.221,6.567-37.974,6.567c-11.23,0-22.552-2.046-33.974-6.136c-11.417-4.093-20.699-8.138-27.834-12.137    c-7.138-3.997-11.281-5.996-12.422-5.996C11.801,164.456,0,198.051,0,265.24c0,14.844,5.33,26.127,15.987,33.83    c10.66,7.707,23.794,11.563,39.397,11.563h38.26C113.251,287.222,138.467,275.042,169.303,274.088z';
    var area_icon = 'M503.639,336.899c-5.328-5.328-11.8-7.994-19.417-7.994h-27.405v-54.819c0-9.896-3.617-18.466-10.848-25.695   c-7.231-7.236-15.804-10.852-25.7-10.852H274.091v-54.818h27.404c7.618,0,14.089-2.664,19.417-7.994   c5.329-5.327,7.991-11.798,7.991-19.414v-91.36c0-7.614-2.662-14.087-7.991-19.414c-5.328-5.33-11.799-7.993-19.417-7.993h-91.361   c-7.614,0-14.084,2.663-19.414,7.993c-5.33,5.327-7.992,11.799-7.992,19.414v91.36c0,7.616,2.662,14.084,7.992,19.414   c5.327,5.33,11.8,7.994,19.414,7.994h27.408v54.818H91.363c-9.898,0-18.462,3.619-25.697,10.852   c-7.233,7.229-10.848,15.799-10.848,25.695v54.819H27.406c-7.611,0-14.084,2.666-19.414,7.994C2.663,342.229,0,348.696,0,356.313   v91.358c0,7.617,2.663,14.089,7.992,19.417c5.33,5.328,11.803,7.991,19.414,7.991h91.365c7.611,0,14.084-2.666,19.414-7.991   c5.33-5.328,7.992-11.8,7.992-19.417v-91.358c0-7.617-2.662-14.085-7.992-19.414c-5.33-5.328-11.803-7.994-19.414-7.994H91.36   v-54.819h146.179v54.819h-27.408c-7.614,0-14.084,2.666-19.414,7.994c-5.33,5.329-7.992,11.797-7.992,19.414v91.358   c0,7.617,2.662,14.089,7.992,19.417c5.327,5.328,11.8,7.991,19.414,7.991h91.361c7.618,0,14.086-2.666,19.418-7.991   c5.325-5.332,7.994-11.8,7.994-19.417v-91.358c0-7.617-2.662-14.085-7.994-19.414c-5.332-5.328-11.8-7.994-19.418-7.994h-27.404   v-54.819h146.182v54.819h-27.412c-7.61,0-14.086,2.666-19.417,7.994c-5.325,5.329-7.987,11.797-7.987,19.414v91.358   c0,7.617,2.662,14.089,7.987,19.417c5.331,5.328,11.807,7.991,19.417,7.991h91.365c7.61,0,14.082-2.666,19.41-7.991   c5.332-5.328,7.994-11.8,7.994-19.417v-91.358C511.626,348.696,508.964,342.229,503.639,336.899z';//图标
    function refresh(refresh_type){
        $.ajax({
            url: '/worktable/backend_refresh/',
            type: 'POST',
            data: {'dashboard': refresh_type},
            dataType: 'json',
            success: function(data){
                var option = {
                    title: gettext("提示"),
                    icon: 1,
                    btn: [],
                    //shade: 0,
                    success: function(layero){
                        parent.layer.setTop(layero);
                    }
                };
                if(data == "OK"){
                    parent.layer.alert(gettext("Backend Processing Of Request, Please Refresh Page Later."), option)
                }else{
                    parent.layer.alert(data, option)
                }
            },
            error: function(){

            },
            complete: function (XHR, TS) {
                XHR = null;
            }
        });
    };
    var window_size = ['290px', '320px'];
    var pChart = echarts.init(document.getElementById('chartPresent'));
    var pDepartments = [];
    var pAreas = [];
    var pie_opt = {
        title : {
            text: gettext('出勤'),
            subtext: gettext('今天'),
            x:'center'
        },
        tooltip : {
            trigger: 'item',
            formatter: "{a} <br/>{b} : {c} ({d}%)"
        },
        toolbox: {
            showTitle: false,
            feature: {
                myArea:{
                    show: true,
                    title: 'Authorize Area', //鼠标移动上去显示的文字
                    icon: area_icon,
                    option:{},
                    onclick:function(option) {//点击事件,这里的option1是chart的option信息
                         var vbox = ""
                            +"  <div id='id_show_p_area_tree' style='overflow: auto;  width:100%'>"
                            +"      <ul id='p_area_tree' ></ul>"
                            +"  </div>"
                        var options = {
                            title: "Area",
                            area: window_size,
                            skin: 'option_dialog',
                            shade: 0,
                            shadeClose: true,
                            btn: [gettext("确认")],
                            btnAlign: 'c',
                            yes: function(index, layero){
                                pAreas = [];
                                $("#p_area_tree input[name=Area]").each(function(){
                                    pAreas.push($(this).val());
                                })
                                layer.close(index);
                            },
                            success: function (layero, index) {
                               $.ajax({
                                    type: "POST",
                                    url: "/data/personnel/Area/choice_data_widget?multiple=True",
                                    traditional: true,
                                    data: {'Area': pAreas},
                                    dataType: "html",
                                    success: function (json) {
                                        $("#p_area_tree").empty();
                                        $("#p_area_tree").html(json);
                                        console.log(pAreas)
                                    }
                                });
                            },
                            //cancel: function(){
                            //    pAreas = [];
                            //    $("#p_area_tree input[name=Area]").each(function(){
                            //        pAreas.push($(this).val());
                            //    })
                            //}
                        }
                        $(vbox).layerDialog(options);
                    }
                },
                myDepartment:{
                    show: true,
                    title: 'Authorize Department', //鼠标移动上去显示的文字
                    icon: department_icon,
                    option:{},
                    onclick:function(option) {//点击事件,这里的option1是chart的option信息
                         var vbox = ""
                            +"  <div id='id_show_p_department_tree' style='overflow: auto;  width:100%'>"
                            +"      <ul id='p_department_tree' ></ul>"
                            +"  </div>"
                        var options = {
                            title: "Department",
                            area: window_size,
                            skin: 'option_dialog',
                            shade: 0,
                            shadeClose: true,
                            btn: [gettext("确认")],
                            btnAlign: 'c',
                            yes: function(index, layero){
                                pDepartments = [];
                                $("#p_department_tree input[name=Department]").each(function(){
                                    pDepartments.push($(this).val());
                                })
                                layer.close(index);
                            },
                            success: function (layero, index) {
                               $.ajax({
                                    type: "POST",
                                    url: "/data/personnel/Department/choice_data_widget?multiple=True",
                                    traditional: true,
                                    data: {'Department': pDepartments},
                                    dataType: "html",
                                    success: function (json) {
                                        $("#p_department_tree").empty();
                                        $("#p_department_tree").html(json);
                                        console.log(pDepartments)
                                    }
                                });
                            },
                            //cancel: function(){
                            //    pDepartments = [];
                            //    $("#p_department_tree input[name=Department]").each(function(){
                            //        pDepartments.push($(this).val());
                            //    })
                            //}
                        }
                        $(vbox).layerDialog(options);
                    }
                },
                myRefresh: {
                    show: true,
                    icon: 'M3.8,33.4 M47,18.9h9.8V8.7 M56.3,20.1 C52.1,9,40.5,0.6,26.8,2.1C12.6,3.7,1.6,16.2,2.1,30.6 M13,41.1H3.1v10.2 M3.7,39.9c4.2,11.1,15.8,19.5,29.5,18 c14.2-1.6,25.2-14.1,24.7-28.5',
                    onclick: function(){
                        refresh('m');
                    }
                },
                saveAsImage: {show: true}
            }
        },
        legend: {
            orient: 'vertical',
            left: 'left',
            data: []
            //data: [gettext('缺勤'), gettext('出勤')]
        },
        series : [
            {
                name: gettext('loading...'),
                type: 'pie',
                radius : '55%',
                center: ['50%', '60%'],
                data:[],
                itemStyle: {
                    normal:{
                        label:{
                           show: true,
                           formatter: '{c} ({d}%)'
                        },
                        labelLine :{show:true}
                    }
                }
            }
        ]
    };
    pChart.showLoading({
        text: gettext('loading...')
    });
    pChart.setOption(pie_opt);
    pChart.on('click', function (params) {
        var url = '/page/att/PresentReport/?pure';
        if(params.dataIndex == 0){
            url = '/page/att/AbsenceReport/?pure';
        }
        layer.open({
            title: params.data.name,
            type: 2,
            area: ['980px', '600px'],
            fixed: false, //不固定
            maxmin: true,
            content: url
        });
    });
    function refreshPie(){
        var url = '/worktable/dashboard_refresh/';
        $.ajax({
            url: url,
            type: 'POST',
            traditional: true,
            data: {'Department': pDepartments, 'Area': pAreas, 'dashboard': 'p'},
            dataType: 'json',
            success: function(data){
                var pOpt = $.extend(true, {}, pie_opt);
                $.extend(pOpt, data);
                pChart.setOption(pOpt);
                pChart.hideLoading();
                window.setTimeout(refreshPie, 2000);
            },
            error: function(){
                pChart.hideLoading();
                window.setTimeout(refreshPie, 2000);
            },
            complete: function (XHR, TS) {
                XHR = null;
            }
        });
    };
    var cChart = echarts.init(document.getElementById('chartCompare'));
    var eDepartments = [];
    var eAreas = [];
    var option = {
        title: {
            text: gettext('异常考勤'),
            subtext: gettext('历史记录'),
            left: 0
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'line'
            }
        },
        toolbox: {
            showTitle: false,
            feature: {
                myArea:{
                    show: true,
                    title: 'Authorize Area', //鼠标移动上去显示的文字
                    icon: area_icon,
                    option:{},
                    onclick:function(option) {//点击事件,这里的option1是chart的option信息
                         var vbox = ""
                            +"  <div id='id_show_e_area_tree' style='overflow: auto;  width:100%'>"
                            +"      <ul id='e_area_tree' ></ul>"
                            +"  </div>"
                        var options = {
                            title: "Area",
                            area: window_size,
                            skin: 'option_dialog',
                            shade: 0,
                            shadeClose: true,
                            btn: [gettext("确认")],
                            btnAlign: 'c',
                            yes: function(index, layero){
                                eAreas = [];
                                $("#e_area_tree input[name=Area]").each(function(){
                                    eAreas.push($(this).val());
                                })
                                layer.close(index);
                            },
                            success: function (layero, index) {
                               $.ajax({
                                    type: "POST",
                                    url: "/data/personnel/Area/choice_data_widget?multiple=True",
                                    traditional: true,
                                    data: {'Area': eAreas},
                                    dataType: "html",
                                    success: function (json) {
                                        $("#e_area_tree").empty();
                                        $("#e_area_tree").html(json);
                                        console.log(eAreas)
                                    }
                                });
                            },
                            //cancel: function(){
                            //    eAreas = [];
                            //    $("#e_area_tree input[name=Area]").each(function(){
                            //        eAreas.push($(this).val());
                            //    })
                            //}
                        }
                        $(vbox).layerDialog(options);
                    }
                },
                myDepartment:{
                    show: true,
                    title: 'Authorize Department', //鼠标移动上去显示的文字
                    icon: department_icon,
                    option:{},
                    onclick:function(option) {//点击事件,这里的option1是chart的option信息
                         var vbox = ""
                            +"  <div id='id_show_e_department_tree' style='overflow: auto;  width:100%'>"
                            +"      <ul id='e_department_tree' ></ul>"
                            +"  </div>"
                        var options = {
                            title: "Department",
                            area: window_size,
                            skin: 'option_dialog',
                            shade: 0,
                            shadeClose: true,
                            btn: [gettext("确认")],
                            btnAlign: 'c',
                            yes: function(index, layero){
                               eDepartments = [];
                                $("#e_department_tree input[name=Department]").each(function(){
                                    eDepartments.push($(this).val());
                                });
                                layer.close(index);
                            },
                            success: function (layero, index) {
                               $.ajax({
                                    type: "POST",
                                    url: "/data/personnel/Department/choice_data_widget?multiple=True",
                                    traditional: true,
                                    data: {'Department': eDepartments},
                                    dataType: "html",
                                    success: function (json) {
                                        $("#e_department_tree").empty();
                                        $("#e_department_tree").html(json);
                                    }
                                });
                            },
                            //cancel: function(){
                            //    eDepartments = [];
                            //    $("#e_department_tree input[name=Department]").each(function(){
                            //        eDepartments.push($(this).val());
                            //    })
                            //}
                        }
                        $(vbox).layerDialog(options);
                    }
                },
                myRefresh: {
                    show: true,
                    icon: 'M3.8,33.4 M47,18.9h9.8V8.7 M56.3,20.1 C52.1,9,40.5,0.6,26.8,2.1C12.6,3.7,1.6,16.2,2.1,30.6 M13,41.1H3.1v10.2 M3.7,39.9c4.2,11.1,15.8,19.5,29.5,18 c14.2-1.6,25.2-14.1,24.7-28.5',
                    onclick: function(){
                        refresh('e');
                    }
                },
                magicType: {type: ['line', 'bar']},
                saveAsImage: {show: true}
            }
        },
        legend: {
            data: []
            //data: [gettext('迟到'), gettext('早退'), gettext('旷工')]
        },
        grid: {
            left: '5%',
            right: '10%',
            bottom: '20%'
        },
        xAxis: {
            type: 'category',
            data: [],
            scale: true,
            boundaryGap : false,
            axisLine: {onZero: false},
            splitLine: {show: false},
            splitNumber: 20,
            min: 'dataMin',
            max: 'dataMax'
        },
        yAxis: {
            scale: true,
            splitArea: {
                show: true
            }
        },
        dataZoom: [
            {
                type: 'inside',
                start: 50,
                end: 100
            },
            {
                show: true,
                type: 'slider',
                y: '90%',
                start: 50,
                end: 100
            }
        ],
        series: [
            {
                name: '',
                type: 'line',
                data: [],
                smooth: true,
                lineStyle: {
                    normal: {opacity: 0.5}
                }
            },
            {
                name: '',
                type: 'line',
                data: [],
                smooth: true,
                lineStyle: {
                    normal: {opacity: 0.5}
                }
            },
            {
                name: '',
                type: 'line',
                data: [],
                smooth: true,
                lineStyle: {
                    normal: {opacity: 0.5}
                }
            }
        ]
    };
    cChart.showLoading({
        text: gettext('loading...')
    });
    cChart.setOption(option);
    function refreshException(){
        var url = '/worktable/dashboard_refresh/';
        $.ajax({
            url: url,
            type: 'POST',
            traditional: true,
            data: {'Department': eDepartments, 'Area': eAreas, 'dashboard': 'e'},
            dataType: 'json',
            success: function(data){
                if(data){
                    var adOpt = $.extend(true, {}, option);
                    $.extend(adOpt, data);
                    cChart.setOption(adOpt);
                    cChart.hideLoading();
                }
            },
            error: function(){
                cChart.hideLoading();
            },
            complete: function (XHR, TS) {
                XHR = null;
            }
        });
    };
    var acChart = echarts.init(document.getElementById('areaCapacity'));
    var mDepartments = [];
    var mAreas = [];
    var real_option = {
        title: {
            //text: gettext('实时监控'),
            text: '',
            //subtext: gettext('今天'),
            left: 0
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'line'
            }
        },
        toolbox: {
            showTitle: false,
            feature: {
                myArea:{
                    show: true,
                    title: 'Authorize Area', //鼠标移动上去显示的文字
                    icon: area_icon,
                    option:{},
                    onclick:function(option) {//点击事件,这里的option1是chart的option信息
                         var vbox = ""
                            +"  <div id='id_show_m_area_tree' style='overflow: auto;  width:100%'>"
                            +"      <ul id='m_area_tree' ></ul>"
                            +"  </div>"
                        var options = {
                            title: "Area",
                            area: window_size,
                            skin: 'option_dialog',
                            shade: 0,
                            shadeClose: true,
                            btn: [gettext("确认")],
                            btnAlign: 'c',
                            yes: function(index, layero){
                                mAreas = [];
                                $("#m_area_tree input[name=Area]").each(function(){
                                    mAreas.push($(this).val());
                                })
                                layer.close(index);
                            },
                            success: function (layero, index) {
                               $.ajax({
                                    type: "POST",
                                    url: "/data/personnel/Area/choice_data_widget?multiple=True",
                                    traditional: true,
                                    data: {'Area': mAreas},
                                    dataType: "html",
                                    success: function (json) {
                                        $("#m_area_tree").empty();
                                        $("#m_area_tree").html(json);
                                        console.log(mAreas)
                                    }
                                });
                            },
                            //cancel: function(){
                            //    mAreas = [];
                            //    $("#m_area_tree input[name=Area]").each(function(){
                            //        mAreas.push($(this).val());
                            //    })
                            //}
                        }
                        $(vbox).layerDialog(options);
                    }
                },
                myDepartment:{
                    show: true,
                    title: 'Authorize Department', //鼠标移动上去显示的文字
                    icon: department_icon,
                    option:{},
                    onclick:function(option) {//点击事件,这里的option1是chart的option信息
                         var vbox = ""
                            +"  <div id='id_show_m_department_tree' style='overflow: auto;  width:100%'>"
                            +"      <ul id='m_department_tree' ></ul>"
                            +"  </div>"
                        var options = {
                            title: "Department",
                            area: window_size,
                            skin: 'option_dialog',
                            shade: 0,
                            shadeClose: true,
                            btn: [gettext("确认")],
                            btnAlign: 'c',
                            yes: function(index, layero){
                                mDepartments = [];
                                $("#m_department_tree input[name=Department]").each(function(){
                                    mDepartments.push($(this).val());
                                })
                                layer.close(index);
                            },
                            success: function (layero, index) {
                               $.ajax({
                                    type: "POST",
                                    url: "/data/personnel/Department/choice_data_widget?multiple=True",
                                    traditional: true,
                                    data: {'Department': mDepartments},
                                    dataType: "html",
                                    success: function (json) {
                                        $("#m_department_tree").empty();
                                        $("#m_department_tree").html(json);
                                        console.log(mDepartments)
                                    }
                                });
                            },
                            //cancel: function(){
                            //    mDepartments = [];
                            //    $("#m_department_tree input[name=Department]").each(function(){
                            //        mDepartments.push($(this).val());
                            //    })
                            //}
                        }
                        $(vbox).layerDialog(options);
                    }
                },
                myRefresh: {
                    show: true,
                    icon: 'M3.8,33.4 M47,18.9h9.8V8.7 M56.3,20.1 C52.1,9,40.5,0.6,26.8,2.1C12.6,3.7,1.6,16.2,2.1,30.6 M13,41.1H3.1v10.2 M3.7,39.9c4.2,11.1,15.8,19.5,29.5,18 c14.2-1.6,25.2-14.1,24.7-28.5',
                    onclick: function(){
                        refresh('m');
                    }
                },
                magicType: {type: ['line', 'bar']},
                saveAsImage: {
                    show: true
                }
            }
        },
        legend: {
            data: [gettext('P')]
        },
        grid: {
            left: '10%',
            right: '5%',
            bottom: '20%'
        },
        xAxis: {
            type: 'category',
            data: [],
            scale: true,
            boundaryGap : false,
            axisLine: {onZero: false},
            splitLine: {show: false},
            splitNumber: 30,
            min: 'dataMin',
            max: 'dataMax'
        },
        yAxis: {
            scale: true,
            splitArea: {
                show: true
            }
        },
        dataZoom: [
            {
                type: 'inside',
                start: 0,
                end: 100
            },
            {
                show: true,
                type: 'slider',
                y: '90%',
                start: 0,
                end: 100
            }
        ],
        series: [
            {
                name: gettext('loading...'),
                type: 'line',
                data: [],
                smooth: true,
                lineStyle: {
                    normal: {opacity: 0.5}
                }
            }
        ]
    };
    acChart.showLoading({
        text: gettext('loading...')
    });
    acChart.setOption(real_option);
    function refreshMonitor(){
        var url = '/worktable/dashboard_refresh/';
        $.ajax({
            url: url,
            type: 'POST',
            traditional: true,
            data: {'Department': mDepartments, 'Area': mAreas, 'dashboard': 'm'},
            dataType: 'json',
            success: function(data){
                if(data){
                    var realOpt = $.extend(true, {}, real_option);
                    $.extend(realOpt, data);
                    acChart.setOption(realOpt);
                    acChart.hideLoading();
                    window.setTimeout(refreshMonitor, 60000);
                }
            },
            error: function(){
                acChart.hideLoading();
                window.setTimeout(refreshMonitor, 60000);
            },
            complete: function (XHR, TS) {
                XHR = null;
            }
        });
    }
    function FillOutData(data){
        var content = "";
        if(data){
            for(var i=0; i < data.length; i++){
                var r = data[i];
                content +=''
                 +'<tr>'
                 +'  <td width="220"><div class="l"  title="'+r[2]+'">'
                 +'      <div class="l"><img class="radius" onerror="this.src=\'/media/images/userImage.gif\'" source="'+r[6]+'" src="'+r[6]+'">'+''+'</div>'
                 +'      <div class="r" style="margin: 3px 3px 3px 3px;width:155px;">'
                 +'      <div style="text-overflow: ellipsis;white-space: nowrap;overflow:hidden;">'+r[1]+'</div>'
                 +'      <div style="text-overflow: ellipsis;white-space: nowrap;overflow:hidden;">'+r[2]+'</div></div>'
                 +'  </div></td>'
                 +'  <td width="160"><div class="l">'
                 +'     <div class="l"><img source="'+r[8]+'" src="'+r[8]+'">'+''+'</div>'
                 +'     <div class="r" style="margin: 3px 3px 3px 3px;width:125px;">'
                 +'     <div style="width:120px;height:20px:center;text-overflow: ellipsis;white-space: nowrap;overflow:hidden;" title="'+r[7]+'">'+r[7]+'</div>'
                 +'     <div style="text-overflow: ellipsis;white-space: nowrap;overflow:hidden;" title="'+r[3]+'">'+r[3]+'</div></div>'
                 +'  </div></td>'
                 +'  <td width="100">'+r[4]+'</td>'
                 +'  <td width="100"><img class="radius" onerror="this.src=\'/media/images/noCapture.png\'" source="'+r[5]+'" src="'+r[5]+'"></td>'
                 +'</tr>';
            }
            $("table.dashboard-table tbody").after(content);
        }
    };
    var score = 0;
    function dashboardRefresh(){
        if($("table.dashboard-table tr").length > 100){
           $("table.dashboard-table tr tr:gt(100)").remove();
        }
        $("table.dashboard-table tr img").each(function() {
            var src = $(this).attr('source');
            $(this).tooltip({
                position: "bottom center",
                opacity: 1.0,
                tip: '#obj_tooltip',
                onBeforeShow: function () {
                    var html = '<div class="big-pic"><img src="'+src+'"></div>';
                    $("#obj_tooltip").html(html);
                }
            });
        });
        var url = '/worktable/dashboard_refresh/'
        $.ajax({
            url: url,
            type: 'POST',
            traditional: true,
            data: {'Department': mDepartments, 'Area': mAreas, 'dashboard': 'r', 'score': score},
            dataType: 'json',
            success: function(data){
                FillOutData(data['data']);
                score = data['score'];
                window.setTimeout(dashboardRefresh, 1500);
            },
            error: function(){
                window.setTimeout(dashboardRefresh, 1500);
            },
            complete: function (XHR, TS) {
                XHR = null;
            }
        });
    }
    function Refresh(){
        refreshPie();
        refreshException();
        dashboardRefresh();
        refreshMonitor();
    }
    window.setTimeout(Refresh, 1000);//第一次刷新等1s执行刷新函数
});
